import es
import random
import playerlib
import gamethread
 
import wcs
from wcs import wcs

raceName = 'Human Alliance'
race     = wcs.Race(raceName)

""" Load the strings into the variable text """
text     = race.loadStrings()

""" ############################### """
""" ### Begin the configuration ### """
""" ############################### """

config   = race.config()

config.addComment()
config.addComment('********************')
config.addComment('Invisibility')
config.addComment('  This skill allows a playe to spawn with a higher invisibility effect')
config.addComment('********************')
config.addComment()
invisMaxlevel      = config.addVar('invisMaxlevel',      6,  'The maximum level of the Invisibility skill')
invisLevelInterval = config.addVar('invisLevelInterval', 2,  'The intervals between the abilities to upgrade their Invisibility skill')
invisibilityRating = config.addVar('invisibilityRating', 20, 'The effect that the invisibility skill will have... A relativly high value is 30, whereas a low value is 10.')

config.addComment()
config.addComment('********************')
config.addComment('Devotion')
config.addComment('  This skill allows a player to spawn with more health')
config.addComment('********************')
config.addComment()
devotMaxlevel        = config.addVar('devotMaxlevel',         4, 'The maximum level of the Devotion skill')
devotLevelInterval   = config.addVar('devotLevelInterval',    1, 'The intervals between the abilities to upgrade their Devotion skill')
devotHealthIncrement = config.addVar('devotHealthIncrement', 15, 'The amount of health devotion gives the player, multiplied by their level') 

config.addComment()
config.addComment('********************')
config.addComment('Bash')
config.addComment('  This skill has a chance to stun enemies')
config.addComment('  every time the player attacks another')
config.addComment('********************')
config.addComment()
bashMaxlevel      = config.addVar('bashMaxlevel',      4, 'The maximum level of the Bash skill')
bashLevelInterval = config.addVar('bashLevelInterval', 3, 'The intervals between the abilities to upgrade their bash skill')
bashPercentage    = config.addVar('bashPercentage',    8, 'The chance a player will stun another when they damage, multiplied via their level')

config.addComment()
config.addComment('********************')
config.addComment('Avatar')
config.addComment('  This ultimate gives the player')
config.addComment('  better attributes for a certain')
config.addComment('  time, including health, speed and')
config.addComment('  extra damage. However, when the effect')
config.addComment('  runs out, the player will be severely')
config.addComment('  vulnerable.')
config.addComment('********************')
config.addComment()
avararMinLevel      = config.addVar('avararMinLevel',      8, 'The level required before a player can buy level 1 in the Avatar Skill')
avatarMaxLevel      = config.addVar('avatarMaxLevel',      3, 'The maximum level of the Avatar skill')
avatarLevelInterval = config.addVar('avatarLevelInterval', 4, 'The intervals between the abilities to upgrade their Avatar skill')
avatarDuration      = config.addVar('avatarDuration',      4, 'The number of seconds multiplied via their level that the Avatar effect will last for')
avatarCoolDown      = config.addVar('avatarCoolDown',      8, 'The amount of seconds after the avatar effect has worn off before the player can use the skill again.')

config.load(True)

""" ##################### """
""" ### END OF CONFIG ### """
""" ##################### """

if wcs.game is not 'Pirates, Vikings, and Knights':
    race.registerSkill('Invisibility', int(invisMaxlevel), int(invisLevelInterval), 'Makes you partially invisible.')
race.registerSkill('Devotion', int(devotMaxlevel), int(devotLevelInterval), 'Gives you additional health each round.')
race.registerSkill('Bash', int(bashMaxlevel), int(bashLevelInterval), 'Have a chance to stun the person you hit with an attack.')
race.registerUltimate('Avatar', int(avararMinLevel), int(avatarLevelInterval), int(avatarLevelInterval), 'Hold down your ultimate key to get stronger for a short time.')

def player_spawn(ev):
    userid = int(ev['userid'])
    if not wcs.GetLevel(userid, raceName, 'Invisibility'):
        wcs.Command(userid).Color(alpha=255)
    invisi(userid)
    devotion = wcs.GetLevel(userid, raceName, 'Devotion') * int(devotHealthIncrement)
    if devotion:
        wcs.Command(userid).HealthAdd(devotion)
        es.tell(userid, '#multi', text('devotion', {'health' : devotion}, playerlib.getPlayer(userid).get("lang") ) )
        wcs.effect.Misc1(userid, 1)
    #wcs.Command(userid).UpdateDict('avatar', 0)
    wcs.Command(userid)['avatar'] = 0
    
def item_pickup(ev):
    userid = int(ev['userid'])
    #avatar = wcs.Command(userid).ReturnDict('avatar')
    avatar = wcs.Command(userid)['avatar']
    if not avatar and wcs.dir != 'pvkii':
        invisi(userid)
        
def player_hurt(ev):
    userid   = int(ev['userid'])
    attacker = int(ev['attacker'])
    if attacker:
        damage = int(ev['dmg_health'])
        bash   = wcs.GetLevel(attacker, raceName, 'Bash') * int(bashPercentage)
        if bash >= random.randint(1,100):
            wcs.effect.Beam1(userid, attacker, 1.5, 0, 0, 255)
            wcs.Command(userid).Freeze(4)
            es.tell(attacker, '#multi', text('bash', {'victim' : es.getplayername(userid)}, playerlib.getPlayer(attacker).get("lang") ) )
        if wcs.dir in ('cstrike', 'dod'):
            avatar = wcs.GetLevel(attacker, raceName, 'Avatar')
            if avatar:
                #state = wcs.Command(attacker).ReturnDict('avatar')
                state = wcs.Command(attacker)['avatar']
                if state:
                    wcs.Command(userid).Damage(damage * .3, 32, attacker)
                    
def player_ultimate_on(event_var):
    userid = int(event_var['userid'])
    avatar = wcs.GetLevel(userid, raceName, 'Avatar') * int(avatarDuration)
    #if ava and not wcs.Command(userid).ReturnDict('avatar'):
    if avatar and not wcs.Command(userid)['avatar']:
        es.tell(userid, '#multi', text('avatar on', {'time' : avatar}, playerlib.getPlayer(userid).get("lang") ) )
        command = wcs.Command(userid)
        #wcs.Command(userid).UpdateDict('avatar', 1)
        command['avatar'] = 1
        command.HealthAdd(100)
        command.Color(blue=255)
        command.Delayed(avatar, avaoff, userid)
        wcs.effect.Ring1(userid, 50, 2, 0, 50, 255)
        
def invisi(userid):
    invis = wcs.GetLevel(userid, raceName, 'Invisibility')
    if invis:
        wcs.Command(userid).Color(alpha = 255 - (invis * int(invisibilityRating) + 90) )
        
def avaoff(userid):
    command = wcs.Command(userid)
    #state = wcs.Command(userid).ReturnDict('avatar')
    state = command['avatar']
    if state:
        es.tell(userid, '#multi', text('avatar off', lang = playerlib.getPlayer(userid).get("lang") ) ) 
        #command.UpdateDict('avatar', 0)
        command['avatar'] = 0
        command.SetCoolDown('Avatar', int(avatarCoolDown) )
        invisi(userid)
        wcs.effect.Ring1(userid, 50, 2, 0, 255, 50)
        if es.getplayerprop(userid, 'CBasePlayer.m_iHealth') >= 101:
            wcs.Command(userid).HealthAdd(-100)
        else:
            wcs.Command(userid).Health(1)
